uint32_t remainder_GF2(uint32_t dividend, uint32_t divisor)
{
    // necessary bit shuffling/negation to make it compatible with other CRC32 implementations.
    // N.B.: input data is not an array, but a 32-bit integer, hence we need to swap endiannes.
    uint32_t dividend_negated_swapped = ~swap_endianness32(bitrev32(dividend));
    buf=(uint8_t*)&dividend_negated_swapped;
    buf_pos=3;
    buf_bit_pos=7;

    uint32_t tmp=0;

    // process 32 bits from the input + 32 zero bits:
    for(int i=0; i<32+32; i++)
    {
        int bit=get_bit();
        int shifted_bit=tmp>>31;

        // fetch next bit:
        tmp=tmp<<1;
        if (bit==-1)
        {
            // no more bits, but continue, we fetch 32 more zero bits.
            // shift left operation set leftmost bit to zero.
        }
        else
        {
            // append next bit at right:
            tmp=tmp|bit;
        };

        // \verb|at this point, tmp variable/value has 33 bits: shifted_bit + tmp|
        // now take the most significant bit (33th) and test it:
        // 33th bit of polynomial (not present in "divisor" variable is always 1
        // \verb|so we have to only check shifted_bit value|
        if (shifted_bit)
        {
            // use only 32 bits of polynomial, ingore 33th bit, which is always 1:
            tmp=tmp^divisor;
        };
    };
    // bit shuffling/negation for compatibility once again:
    return ~bitrev32(tmp);
}
