#!/usr/bin/env python3
import math

# first prime less than $2^{32}$, IOW, closest
p=4294967291 # 0xfffffffb

# modulo inverse exist for any divisior, since any divisior<p is coprime to p, since p is prime
# for prime p, EulerPhi[p]=p-1
def test(divisor):
    # calculate modulo inverse: $divisor^{p-2} \pmod p$
    mod_inv=pow(divisor, p-2, p)

    i=12340
    r1=(i/divisor) % p
    r2=(i*mod_inv) % p
    assert r1==r2

test(2)
test(5)
test(10)
test(1234)

