#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <math.h>
#include <errno.h>
#include <fenv.h>

const int FloatExpLen = 8;
const int FloatMantissaLen = 23;
const int FloatBits = FloatExpLen + FloatMantissaLen + 1;

void print_float_in_binary (float a)
{
    uint32_t t;
    memcpy (&t, &a, sizeof(float));

    // sign
    printf ("%d ", (t>>(FloatBits-1))&1);

    // exponent
    for (int i=(FloatBits-2);
        i!=(FloatBits-2)-FloatExpLen;
        i--)
        printf ("%d", (t>>i)&1);
    printf (" ");

    // mantissa
    for (int i=(FloatBits-2)-FloatExpLen;
        i>=0;
        i--)
        printf ("%d", (t>>i)&1);
    printf (" 0x%08x", t);
};

int main()
{
    float a;
    //double a; // this will fix it
    int i;

    printf ("0.1: ");
    print_float_in_binary(0.1);
    printf ("\n");

    a = 0.0;
    printf ("a = 0.0;\n");
    printf ("%f %e ", a, a);
    print_float_in_binary(a);
    printf ("\n");
    feclearexcept(FE_ALL_EXCEPT);
    a += 0.1;
    if(fetestexcept(FE_INEXACT))
        printf ("FE_INEXACT\n");
    printf ("a += 0.1;\n");
    printf ("%f %e ", a, a);
    print_float_in_binary(a);
    printf ("\n");
    feclearexcept(FE_ALL_EXCEPT);
    a -= 0.1;

    if(fetestexcept(FE_INEXACT))
        printf ("FE_INEXACT\n");
    printf ("a -= 0.1;\n");
    printf ("%f %e ", a, a);
    print_float_in_binary(a);
    printf ("\n");

    if (a==0.0)
        printf ("a==0\n");
    else
        printf ("a!=0\n");

    for (i = 0; a < 1.0; i++) 
    {
        printf ("i=%d ", i);
        printf ("%f %e ", a, a);
        print_float_in_binary(a);
        printf ("\n");
        a += a;
    };

    printf("i=%d, a=%f %e\n", i, a, a);

    return 0;
}

/* vi: set sw=4 ts=4: */

