(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     57672,       1434]
NotebookOptionsPosition[     48593,       1278]
NotebookOutlinePosition[     48958,       1294]
CellTagsIndexPosition[     48915,       1291]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"FloatExpLen", "=", "8"}], ";"}]], "Input",
 CellChangeTimes->{{3.820904350775402*^9, 3.8209043755310717`*^9}, 
   3.820904427108082*^9, {3.8209044588194447`*^9, 3.82090448426327*^9}, {
   3.820928506627116*^9, 3.820928507108264*^9}, {3.820928781350259*^9, 
   3.8209288442079372`*^9}, {3.8209295545766773`*^9, 3.8209295585281076`*^9}},
 
 CellLabel->"In[63]:=",ExpressionUUID->"188f409f-567c-4f1b-b03c-4c581df6d43e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FloatMantissaLen", "=", "23"}], ";"}]], "Input",
 CellChangeTimes->{{3.820904350775402*^9, 3.8209043755310717`*^9}, 
   3.820904427108082*^9, {3.8209044588194447`*^9, 3.82090448426327*^9}, {
   3.820928506627116*^9, 3.820928507108264*^9}, {3.820928781350259*^9, 
   3.8209288442079372`*^9}, {3.8209295545766773`*^9, 3.820929564579265*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"c062faf5-bdfe-4789-b81d-de774dedb2dd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FloatBits", "=", 
   RowBox[{"FloatExpLen", "+", "FloatMantissaLen", "+", "1"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.820904350775402*^9, 3.8209043755310717`*^9}, 
   3.820904427108082*^9, {3.8209044588194447`*^9, 3.82090448426327*^9}, {
   3.820928506627116*^9, 3.820928507108264*^9}, {3.820928781350259*^9, 
   3.8209288601825237`*^9}, {3.820929324220642*^9, 3.820929327476068*^9}, {
   3.8209295698021708`*^9, 3.820929573245408*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"bac939df-2af5-4259-93ce-d053a209bca7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FloatMaxExponent", "=", 
   RowBox[{
    RowBox[{"BitShiftLeft", "[", 
     RowBox[{"1", ",", 
      RowBox[{"FloatExpLen", "-", "1"}]}], "]"}], "-", "1"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.820904350775402*^9, 3.8209043755310717`*^9}, 
   3.820904427108082*^9, {3.8209044588194447`*^9, 3.82090448426327*^9}, {
   3.820928506627116*^9, 3.820928507108264*^9}, {3.820928781350259*^9, 
   3.8209288601825237`*^9}, {3.820929324220642*^9, 3.820929333914043*^9}, 
   3.8209303913647137`*^9},
 CellLabel->"In[66]:=",ExpressionUUID->"587aee54-40b1-477d-a7e9-058a41733cd7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FloatExpMask", "=", 
   RowBox[{
    RowBox[{"BitShiftLeft", "[", 
     RowBox[{"1", ",", "FloatExpLen"}], "]"}], "-", "1"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.820904350775402*^9, 3.8209043755310717`*^9}, 
   3.820904427108082*^9, {3.8209044588194447`*^9, 3.82090448426327*^9}, {
   3.820928506627116*^9, 3.820928507108264*^9}, {3.820928781350259*^9, 
   3.820928855908997*^9}, {3.820928988408991*^9, 3.8209290469266644`*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"d11f61b1-903a-4e52-98af-6b0b3e7d37db"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FloatMantissaMask", "=", 
   RowBox[{
    RowBox[{"BitShiftLeft", "[", 
     RowBox[{"1", ",", "FloatMantissaLen"}], "]"}], "-", "1"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.820904350775402*^9, 3.8209043755310717`*^9}, 
   3.820904427108082*^9, {3.8209044588194447`*^9, 3.82090448426327*^9}, {
   3.820928506627116*^9, 3.820928507108264*^9}, {3.820928781350259*^9, 
   3.820928855908997*^9}, {3.820928988408991*^9, 3.8209290134550743`*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"2148dff4-6723-4725-a551-169e8d422b4e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"convertFloatSubnormal", "[", 
   RowBox[{"sign_", ",", " ", "mantissa_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "^", "sign"}], "*", 
   RowBox[{"(", 
    RowBox[{"mantissa", "/", 
     RowBox[{"(", 
      RowBox[{"BitShiftLeft", "[", 
       RowBox[{"1", ",", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"FloatBits", "-", 
            RowBox[{"(", 
             RowBox[{"FloatExpLen", "+", "1"}], ")"}]}], ")"}], "+", 
          "FloatMaxExponent", "-", "1"}], ")"}]}], "]"}], ")"}]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.820904350775402*^9, 3.8209043755310717`*^9}, 
   3.820904427108082*^9, {3.8209044588194447`*^9, 3.82090448426327*^9}, {
   3.820928506627116*^9, 3.820928507108264*^9}, {3.820928781350259*^9, 
   3.820928799097601*^9}, {3.820928865267272*^9, 3.82092887612245*^9}, {
   3.8209293757386847`*^9, 3.820929379625574*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"aa7ede3b-82eb-43da-bc7d-0363cc20e509"],

Cell[BoxData[
 RowBox[{
  RowBox[{"convertFloatNaN", "[", 
   RowBox[{"sign_", ",", " ", "exp_", ",", " ", "mantissa_"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"mantissa", "\[Equal]", "0"}], " ", ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"sign", "\[Equal]", "0"}], ",", "\"\<Inf\>\"", ",", 
      "\"\<-Inf\>\""}], "]"}], ",", " ", "\"\<NaN\>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.820904970008232*^9, 3.8209050388342543`*^9}, {
  3.820905112820662*^9, 3.8209051282745256`*^9}, {3.820928510861203*^9, 
  3.820928511307817*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"fd8ff10e-c169-460e-aaa6-d6b6f166954c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"convertFloatNormal", "[", 
   RowBox[{"sign_", ",", " ", "exp_", ",", " ", "mantissa_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "^", "sign"}], "*", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"BitShiftLeft", "[", 
       RowBox[{"1", ",", "FloatMantissaLen"}], "]"}], "+", "mantissa"}], 
     ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", "^", 
      RowBox[{"(", 
       RowBox[{"FloatMantissaLen", "-", 
        RowBox[{"(", 
         RowBox[{"exp", "-", "FloatMaxExponent"}], ")"}]}], ")"}]}], 
     ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.820905434638431*^9, 3.820905492961619*^9}, {
  3.820905543638837*^9, 3.8209055437140627`*^9}, {3.820928513681625*^9, 
  3.8209285141459093`*^9}, {3.820928883182601*^9, 3.8209288892264547`*^9}, {
  3.820929341028186*^9, 3.820929341729734*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"f56ad711-c795-4094-88c9-b608d7efbac1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"convertFloat", "[", 
   RowBox[{"sign_", ",", " ", "exp_", ",", " ", "mantissa_"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"exp", "\[Equal]", "FloatExpMask"}], ",", 
    RowBox[{"convertFloatNaN", "[", 
     RowBox[{"sign", ",", "exp", ",", "mantissa"}], "]"}], ",", " ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"exp", "\[Equal]", "0"}], ",", 
      RowBox[{"convertFloatSubnormal", "[", 
       RowBox[{"sign", ",", " ", "mantissa"}], "]"}], ",", " ", 
      RowBox[{"convertFloatNormal", "[", 
       RowBox[{"sign", ",", " ", "exp", ",", " ", "mantissa"}], "]"}]}], 
     "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8209045511844797`*^9, 3.8209045789404716`*^9}, {
  3.820904902222818*^9, 3.820904911886994*^9}, {3.820904958375478*^9, 
  3.820904966365316*^9}, {3.820928423841785*^9, 3.820928430942713*^9}, {
  3.820928517041047*^9, 3.820928528955208*^9}, {3.820929859500112*^9, 
  3.820929861702491*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"629c0957-46c9-4a18-8ec5-578005987b49"],

Cell[BoxData[
 RowBox[{
  RowBox[{"convertFloatDWORD", "[", "dw_", "]"}], ":=", 
  RowBox[{"convertFloat", "[", 
   RowBox[{
    RowBox[{"BitShiftRight", "[", 
     RowBox[{"dw", ",", 
      RowBox[{"FloatBits", "-", "1"}]}], "]"}], ",", 
    RowBox[{"BitAnd", "[", 
     RowBox[{
      RowBox[{"BitShiftRight", "[", 
       RowBox[{"dw", ",", "FloatMantissaLen"}], "]"}], ",", "FloatExpMask"}], 
     "]"}], ",", 
    RowBox[{"BitAnd", "[", 
     RowBox[{"dw", ",", "FloatMantissaMask"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.820904638914628*^9, 3.8209046781999683`*^9}, {
  3.82090474129154*^9, 3.820904744887141*^9}, {3.820904842514371*^9, 
  3.820904851656302*^9}, {3.820928532486209*^9, 3.8209285406026*^9}, {
  3.820928902827817*^9, 3.8209290404415407`*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"8ada960b-b2a2-4a4a-a40e-343b3c34c09a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"convertFloatDWORD", "[", "16^^3dcccccd", "]"}], ",", "100"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.82092854917411*^9, 3.820928566344048*^9}, {
  3.821073302870287*^9, 3.821073305810936*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"bb8fe085-94ea-4257-a967-93925368a1b9"],

Cell[BoxData["0.100000001490116119384765625`100."], "Output",
 CellChangeTimes->{{3.820928563725745*^9, 3.8209285665382013`*^9}, 
   3.82092889481951*^9, 3.8209289446387444`*^9, 3.820928977004181*^9, {
   3.820929007966177*^9, 3.820929058403816*^9}, 3.82092934549407*^9, 
   3.820929384331403*^9, 3.8209295277107153`*^9, 3.820929580570148*^9, 
   3.82092986349465*^9, 3.820930038534343*^9, 3.820997990121419*^9, 
   3.821070306709758*^9, {3.821073296981325*^9, 3.821073306114887*^9}, 
   3.821075524078738*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"af3e440f-e541-4fe2-8679-12137866537a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"convertFloatDWORD", "[", "0", "]"}], "//", "N"}]], "Input",
 CellChangeTimes->{3.820929394109683*^9},
 CellLabel->"In[75]:=",ExpressionUUID->"3cfd193f-d28d-4829-9582-e51a589f7c57"],

Cell[BoxData["0.`"], "Output",
 CellChangeTimes->{3.8209293943791428`*^9, 3.820929527825459*^9, 
  3.820929580696863*^9, 3.8209298646451483`*^9, 3.820930038629094*^9, 
  3.820997990306188*^9, 3.821070306873955*^9, 3.8210755241978207`*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"bfc1dff3-2b00-437e-ab73-599acb56a487"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"convertFloatDWORD", "[", "16^^3f800000", "]"}], ",", "100"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8209294076556168`*^9, 3.820929413432102*^9}, {
  3.821073314946146*^9, 3.821073316753978*^9}},
 CellLabel->"In[76]:=",ExpressionUUID->"805e3d2e-49de-4575-a8fb-194815c1b09f"],

Cell[BoxData["1.`100."], "Output",
 CellChangeTimes->{3.820929413871419*^9, 3.820929527944949*^9, 
  3.820929580823613*^9, 3.820929866184556*^9, 3.820930038736163*^9, 
  3.8209979904128447`*^9, 3.821070307136547*^9, 3.821073316988255*^9, 
  3.8210755243178988`*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"0305b7b2-2254-4628-aff3-ce2cd0d495d1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"convertFloatDWORD", "[", "16^^bf800000", "]"}], "//", 
  "N"}]], "Input",
 CellChangeTimes->{{3.820929426063686*^9, 3.820929426144537*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"9fd06b3e-457a-4106-9cd1-072480eb364b"],

Cell[BoxData[
 RowBox[{"-", "1.`"}]], "Output",
 CellChangeTimes->{3.820929426433873*^9, 3.820929528058487*^9, 
  3.820929580952914*^9, 3.820929867530901*^9, 3.8209300388442993`*^9, 
  3.820997990427725*^9, 3.82107030716187*^9, 3.821075524431468*^9},
 CellLabel->"Out[77]=",ExpressionUUID->"6152fc81-0bc2-441f-b736-0cc18dd915c2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"convertFloatDWORD", "[", "16^^390173f8", "]"}], "//", 
  "N"}]], "Input",
 CellChangeTimes->{{3.8209294423079863`*^9, 3.820929446388796*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"473117a0-798d-42e5-8454-4c91e9c7618d"],

Cell[BoxData["0.000123456004075706`"], "Output",
 CellChangeTimes->{3.820929446767519*^9, 3.8209295281711617`*^9, 
  3.820929581093854*^9, 3.820930038954749*^9, 3.820997990515773*^9, 
  3.8210703073702297`*^9, 3.8210755245313787`*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"a6ac8a6a-9e4c-4434-89b1-84bf7fb81021"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"convertFloatDWORD", "[", "16^^ffffffff", "]"}], "//", 
  "N"}]], "Input",
 CellChangeTimes->{{3.820929468592432*^9, 3.820929470003099*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"c4b51dc7-f933-4b55-bb3c-3b103697b4de"],

Cell[BoxData["\<\"NaN\"\>"], "Output",
 CellChangeTimes->{3.820929470268838*^9, 3.8209295282803917`*^9, 
  3.8209295812769012`*^9, 3.820930039050967*^9, 3.820997990644507*^9, 
  3.82107030759107*^9, 3.821075524643062*^9},
 CellLabel->"Out[79]=",ExpressionUUID->"269b9dd4-a13f-4f15-a202-962253caa6ac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"convertFloatDWORD", "[", "16^^ff800000", "]"}], "//", 
  "N"}]], "Input",
 CellChangeTimes->{{3.820929505771716*^9, 3.8209295094009857`*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"250cc3a9-74a4-4359-b680-50ac47e0b585"],

Cell[BoxData["\<\"-Inf\"\>"], "Output",
 CellChangeTimes->{{3.820929509756933*^9, 3.820929528403126*^9}, 
   3.8209295814035273`*^9, 3.820930039154001*^9, 3.820997990764535*^9, 
   3.821070307714026*^9, 3.821075524754517*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"023e49f1-cbe7-4156-9655-cfcfc81ac821"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"convertFloatDWORD", "[", "16^^7f800000", "]"}], "//", 
  "N"}]], "Input",
 CellChangeTimes->{{3.820929517044676*^9, 3.820929523332182*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"f63f463f-88c9-4358-b3af-a4e8715d7183"],

Cell[BoxData["\<\"Inf\"\>"], "Output",
 CellChangeTimes->{{3.820929523714204*^9, 3.82092952857747*^9}, 
   3.8209295814209967`*^9, 3.8209300392532988`*^9, 3.820997990858633*^9, 
   3.821070307826419*^9, 3.8210755248912697`*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"daa294b3-551d-49b8-8d69-dd6824bbf334"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"DoubleExpLen", "=", "11"}], ";"}]], "Input",
 CellChangeTimes->{{3.820904350775402*^9, 3.8209043755310717`*^9}, 
   3.820904427108082*^9, {3.8209044588194447`*^9, 3.82090448426327*^9}, {
   3.820928506627116*^9, 3.820928507108264*^9}, {3.820928781350259*^9, 
   3.8209288442079372`*^9}, {3.8209295545766773`*^9, 
   3.8209295585281076`*^9}, {3.8209297307095013`*^9, 3.820929740577763*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"dc32e443-46db-417a-aa3c-629621e96aa0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DoubleMantissaLen", "=", "52"}], ";"}]], "Input",
 CellChangeTimes->{{3.820904350775402*^9, 3.8209043755310717`*^9}, 
   3.820904427108082*^9, {3.8209044588194447`*^9, 3.82090448426327*^9}, {
   3.820928506627116*^9, 3.820928507108264*^9}, {3.820928781350259*^9, 
   3.8209288442079372`*^9}, {3.8209295545766773`*^9, 3.820929564579265*^9}, {
   3.8209297428523197`*^9, 3.820929748619608*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"583e15c4-720e-4270-b729-39403b8e0ce5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DoubleBits", "=", 
   RowBox[{"DoubleExpLen", "+", "DoubleMantissaLen", "+", "1"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.820904350775402*^9, 3.8209043755310717`*^9}, 
   3.820904427108082*^9, {3.8209044588194447`*^9, 3.82090448426327*^9}, {
   3.820928506627116*^9, 3.820928507108264*^9}, {3.820928781350259*^9, 
   3.8209288601825237`*^9}, {3.820929324220642*^9, 3.820929327476068*^9}, {
   3.8209295698021708`*^9, 3.820929573245408*^9}, {3.82092975032935*^9, 
   3.8209297583614902`*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"718d6026-8023-4564-a8d8-759f3f8a244c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DoubleMaxExponent", "=", 
   RowBox[{
    RowBox[{"BitShiftLeft", "[", 
     RowBox[{"1", ",", 
      RowBox[{"DoubleExpLen", "-", "1"}]}], "]"}], "-", "1"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.820904350775402*^9, 3.8209043755310717`*^9}, 
   3.820904427108082*^9, {3.8209044588194447`*^9, 3.82090448426327*^9}, {
   3.820928506627116*^9, 3.820928507108264*^9}, {3.820928781350259*^9, 
   3.8209288601825237`*^9}, {3.820929324220642*^9, 3.820929333914043*^9}, {
   3.8209297608715973`*^9, 3.820929765323187*^9}, 3.820930395121932*^9},
 CellLabel->"In[85]:=",ExpressionUUID->"101a0a72-1cb8-41fb-af46-0c270753c6c9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DoubleExpMask", "=", 
   RowBox[{
    RowBox[{"BitShiftLeft", "[", 
     RowBox[{"1", ",", "DoubleExpLen"}], "]"}], "-", "1"}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.820904350775402*^9, 3.8209043755310717`*^9}, 
   3.820904427108082*^9, {3.8209044588194447`*^9, 3.82090448426327*^9}, {
   3.820928506627116*^9, 3.820928507108264*^9}, {3.820928781350259*^9, 
   3.820928855908997*^9}, {3.820928988408991*^9, 3.8209290469266644`*^9}, {
   3.8209297738098383`*^9, 3.820929779515006*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"824acd42-4e4d-4397-9662-6b690e37423a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DoubleMantissaMask", "=", 
   RowBox[{
    RowBox[{"BitShiftLeft", "[", 
     RowBox[{"1", ",", "DoubleMantissaLen"}], "]"}], "-", "1"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.820904350775402*^9, 3.8209043755310717`*^9}, 
   3.820904427108082*^9, {3.8209044588194447`*^9, 3.82090448426327*^9}, {
   3.820928506627116*^9, 3.820928507108264*^9}, {3.820928781350259*^9, 
   3.820928855908997*^9}, {3.820928988408991*^9, 3.8209290134550743`*^9}, {
   3.8209297850940533`*^9, 3.820929789128895*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"67329a55-0dea-4291-8c92-f825fb9124ac"],

Cell[BoxData[
 RowBox[{
  RowBox[{"convertDoubleSubnormal", "[", 
   RowBox[{"sign_", ",", " ", "mantissa_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "^", "sign"}], "*", 
   RowBox[{"(", 
    RowBox[{"mantissa", "/", 
     RowBox[{"(", 
      RowBox[{"BitShiftLeft", "[", 
       RowBox[{"1", ",", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"DoubleBits", "-", 
            RowBox[{"(", 
             RowBox[{"DoubleExpLen", "+", "1"}], ")"}]}], ")"}], "+", 
          "DoubleMaxExponent", "-", "1"}], ")"}]}], "]"}], ")"}]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.820904350775402*^9, 3.8209043755310717`*^9}, 
   3.820904427108082*^9, {3.8209044588194447`*^9, 3.82090448426327*^9}, {
   3.820928506627116*^9, 3.820928507108264*^9}, {3.820928781350259*^9, 
   3.820928799097601*^9}, {3.820928865267272*^9, 3.82092887612245*^9}, {
   3.8209293757386847`*^9, 3.820929379625574*^9}, {3.820929795368146*^9, 
   3.820929813608494*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"e42fd4ce-7ba6-4dfd-ac0c-e18c7d16d672"],

Cell[BoxData[
 RowBox[{
  RowBox[{"convertDoubleNaN", "[", 
   RowBox[{"sign_", ",", " ", "exp_", ",", " ", "mantissa_"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"mantissa", "\[Equal]", "0"}], " ", ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"sign", "\[Equal]", "0"}], ",", "\"\<Inf\>\"", ",", 
      "\"\<-Inf\>\""}], "]"}], ",", " ", "\"\<NaN\>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.820904970008232*^9, 3.8209050388342543`*^9}, {
  3.820905112820662*^9, 3.8209051282745256`*^9}, {3.820928510861203*^9, 
  3.820928511307817*^9}, {3.8209298193233843`*^9, 3.820929820138073*^9}},
 CellLabel->"In[89]:=",ExpressionUUID->"423b7336-e765-4818-8737-f086af2be42f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"convertDoubleNormal", "[", 
   RowBox[{"sign_", ",", " ", "exp_", ",", " ", "mantissa_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "^", "sign"}], "*", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"BitShiftLeft", "[", 
       RowBox[{"1", ",", "DoubleMantissaLen"}], "]"}], "+", "mantissa"}], 
     ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", "^", 
      RowBox[{"(", 
       RowBox[{"DoubleMantissaLen", "-", 
        RowBox[{"(", 
         RowBox[{"exp", "-", "DoubleMaxExponent"}], ")"}]}], ")"}]}], 
     ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.820905434638431*^9, 3.820905492961619*^9}, {
  3.820905543638837*^9, 3.8209055437140627`*^9}, {3.820928513681625*^9, 
  3.8209285141459093`*^9}, {3.820928883182601*^9, 3.8209288892264547`*^9}, {
  3.820929341028186*^9, 3.820929341729734*^9}, {3.8209298252115192`*^9, 
  3.8209298421924*^9}},
 CellLabel->"In[90]:=",ExpressionUUID->"4c13ce6c-3a4c-4cd5-a5c9-58fd398b7d2d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"convertDouble", "[", 
   RowBox[{"sign_", ",", " ", "exp_", ",", " ", "mantissa_"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"exp", "\[Equal]", "DoubleExpMask"}], ",", 
    RowBox[{"convertDoubleNaN", "[", 
     RowBox[{"sign", ",", "exp", ",", "mantissa"}], "]"}], ",", " ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"exp", "\[Equal]", "0"}], ",", 
      RowBox[{"convertDoubleSubnormal", "[", 
       RowBox[{"sign", ",", " ", "mantissa"}], "]"}], ",", " ", 
      RowBox[{"convertDoubleNormal", "[", 
       RowBox[{"sign", ",", " ", "exp", ",", " ", "mantissa"}], "]"}]}], 
     "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8209045511844797`*^9, 3.8209045789404716`*^9}, {
  3.820904902222818*^9, 3.820904911886994*^9}, {3.820904958375478*^9, 
  3.820904966365316*^9}, {3.820928423841785*^9, 3.820928430942713*^9}, {
  3.820928517041047*^9, 3.820928528955208*^9}, {3.82092984704541*^9, 
  3.820929847840921*^9}, {3.820929893081437*^9, 3.820929909870062*^9}},
 CellLabel->"In[91]:=",ExpressionUUID->"03fc0046-e644-4e61-ad6f-f220d888225b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"convertDoubleQWORD", "[", "dw_", "]"}], ":=", 
  RowBox[{"convertDouble", "[", 
   RowBox[{
    RowBox[{"BitShiftRight", "[", 
     RowBox[{"dw", ",", 
      RowBox[{"DoubleBits", "-", "1"}]}], "]"}], ",", 
    RowBox[{"BitAnd", "[", 
     RowBox[{
      RowBox[{"BitShiftRight", "[", 
       RowBox[{"dw", ",", "DoubleMantissaLen"}], "]"}], ",", 
      "DoubleExpMask"}], "]"}], ",", 
    RowBox[{"BitAnd", "[", 
     RowBox[{"dw", ",", "DoubleMantissaMask"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.820904638914628*^9, 3.8209046781999683`*^9}, {
  3.82090474129154*^9, 3.820904744887141*^9}, {3.820904842514371*^9, 
  3.820904851656302*^9}, {3.820928532486209*^9, 3.8209285406026*^9}, {
  3.820928902827817*^9, 3.8209290404415407`*^9}, {3.8209299139679193`*^9, 
  3.820929938379449*^9}},
 CellLabel->"In[92]:=",ExpressionUUID->"9232e86e-171f-4a90-b8f3-8d1806a8042d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"two", "=", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"convertDoubleQWORD", "[", "16^^3fc999999999999a", "]"}], ",", 
    "200"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.82092994249197*^9, 3.820929960214056*^9}, {
  3.820930122283801*^9, 3.820930128914517*^9}, {3.820930784880365*^9, 
  3.820930785353896*^9}},
 CellLabel->"In[93]:=",ExpressionUUID->"ba521d93-db3c-49c6-a60a-0d352454d220"],

Cell[BoxData["0.200000000000000011102230246251565404236316680908203125`200."],\
 "Output",
 CellChangeTimes->{{3.820929957442389*^9, 3.8209299604293747`*^9}, 
   3.8209300397957277`*^9, {3.820930125053733*^9, 3.820930129271839*^9}, 
   3.820930785716359*^9, 3.820930939620509*^9, 3.820997991300536*^9, 
   3.821070308037479*^9, 3.821075525096879*^9},
 CellLabel->"Out[93]=",ExpressionUUID->"27eb767f-35a8-45a5-b112-51abb1b44e17"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"three", "=", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"convertDoubleQWORD", "[", "16^^3fd3333333333334", "]"}], ",", 
    "200"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.820929968178892*^9, 3.820929976931859*^9}, {
   3.820930114985325*^9, 3.820930130729855*^9}, {3.820930788109551*^9, 
   3.8209307887651443`*^9}, 3.8209309158567743`*^9, 3.821002360223516*^9},
 CellLabel->"In[94]:=",ExpressionUUID->"459fc1ed-9682-4d16-ac21-922fa650f5a0"],

Cell[BoxData["0.3000000000000000444089209850062616169452667236328125`200."], \
"Output",
 CellChangeTimes->{
  3.820929977333212*^9, 3.820930039896061*^9, {3.820930117234584*^9, 
   3.820930131212331*^9}, 3.820930789112852*^9, {3.8209309168413353`*^9, 
   3.820930940762636*^9}, 3.820997991558498*^9, 3.821002360777*^9, 
   3.821070308165388*^9, 3.82107552520074*^9},
 CellLabel->"Out[94]=",ExpressionUUID->"70162768-8c80-470f-807a-4b89addc2ca6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"convertDoubleQWORD", "[", "16^^3c90000000000000", "]"}], ",", 
   "200"}], "]"}]], "Input",
 CellChangeTimes->{{3.8209299979412413`*^9, 3.820930000584655*^9}, {
  3.820931697183675*^9, 3.820931700043263*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"8f9e6fe9-b026-44c7-b44c-ca51ee69439a"],

Cell[BoxData["5.5511151231257827021181583404541015625`200.*^-17"], "Output",
 CellChangeTimes->{{3.8209299989975233`*^9, 3.820930000924605*^9}, 
   3.820930040032248*^9, 3.8209317004479427`*^9, 3.820997991904155*^9, 
   3.821070308331421*^9, 3.821075525307899*^9},
 CellLabel->"Out[95]=",ExpressionUUID->"0a0565b3-df1d-4533-b42a-62278f07c5bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"one", "=", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"convertDoubleQWORD", "[", "16^^3fb999999999999a", "]"}], ",", 
    "200"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8209307569106007`*^9, 3.820930765948367*^9}},
 CellLabel->"In[96]:=",ExpressionUUID->"405849d7-58c7-4728-aed7-deee704473af"],

Cell[BoxData["0.1000000000000000055511151231257827021181583404541015625`200."]\
, "Output",
 CellChangeTimes->{
  3.8209307667558804`*^9, {3.820930929490645*^9, 3.8209309368778267`*^9}, 
   3.820997991994483*^9, 3.821070308468195*^9, 3.821075525415524*^9},
 CellLabel->"Out[96]=",ExpressionUUID->"d68aa6d2-b006-4e4c-83af-a17de987df44"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"one", "+", "two"}]], "Input",
 CellChangeTimes->{{3.8209307913455143`*^9, 3.820930842498087*^9}, {
  3.820930947938849*^9, 3.8209309488767633`*^9}, {3.820931130046741*^9, 
  3.820931152763043*^9}},
 CellLabel->"In[97]:=",ExpressionUUID->"0f4a1613-ba6b-4d6d-803e-c766311e04e8"],

Cell[BoxData["0.3000000000000000166533453693773481063544750213623046875`200."]\
, "Output",
 CellChangeTimes->{{3.8209307935631113`*^9, 3.8209308427427597`*^9}, {
   3.8209309313832903`*^9, 3.82093094909451*^9}, {3.8209311305466833`*^9, 
   3.820931153053894*^9}, 3.8209979920895443`*^9, 3.821070308714315*^9, 
   3.821075525526491*^9},
 CellLabel->"Out[97]=",ExpressionUUID->"9e1acd29-e22a-41fb-a2a1-237469aed4b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["three"], "Input",
 CellChangeTimes->{{3.820930810571392*^9, 3.820930810986766*^9}},
 CellLabel->"In[98]:=",ExpressionUUID->"3e3b5804-f0a7-439d-8803-ef1fdd97b272"],

Cell[BoxData["0.3000000000000000444089209850062616169452667236328125`200."], \
"Output",
 CellChangeTimes->{3.820930811189247*^9, 3.820930944617977*^9, 
  3.8209979921840363`*^9, 3.821070308836314*^9, 3.821075525541266*^9},
 CellLabel->"Out[98]=",ExpressionUUID->"f54f06b0-32a3-4877-8782-0f8cd503b404"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"one", "+", "two", "+", "three"}]], "Input",
 CellChangeTimes->{{3.8209311953710938`*^9, 3.820931196137251*^9}},
 CellLabel->"In[99]:=",ExpressionUUID->"c99c4855-daff-4c4a-a845-11a0a5b0060b"],

Cell[BoxData["0.6000000000000000610622663543836097232997417449951171875`200."]\
, "Output",
 CellChangeTimes->{3.8209311963904753`*^9, 3.820997992279244*^9, 
  3.821070308951002*^9, 3.8210755256479187`*^9},
 CellLabel->"Out[99]=",ExpressionUUID->"b30a087a-32a1-4221-9258-3a062bd6043c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"convertDoubleQWORD", "[", "1", "]"}], ",", "200"}], 
  "]"}]], "Input",
 CellChangeTimes->{3.820931994974236*^9},
 CellLabel->
  "In[100]:=",ExpressionUUID->"2b523486-60cc-48f1-b096-264167a946a9"],

Cell[BoxData["4.\
940656458412465441765687928682213723650598026143247644255856825006755072702087\
518652998363616359923797965646954457177309266567103559397963987747960107818781\
26300713190311404527845817167848982103688718636056998730723`200.*^-324"], \
"Output",
 CellChangeTimes->{3.82093199566321*^9, 3.820997992375394*^9, 
  3.8210703089689913`*^9, 3.821075525752767*^9},
 CellLabel->
  "Out[100]=",ExpressionUUID->"f510c1f2-5609-46b4-943c-18dbbf8bee6b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"convertDoubleQWORD", "[", "16^^3fd3333333333333", "]"}], ",", 
    "200"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.820932047700798*^9, 3.820932047807308*^9}},
 CellLabel->
  "In[101]:=",ExpressionUUID->"dcad13e8-9e57-42d8-a08f-5d59904c3de1"],

Cell[BoxData["0.299999999999999988897769753748434595763683319091796875`200."],\
 "Output",
 CellChangeTimes->{{3.820932040497813*^9, 3.8209320481912394`*^9}, 
   3.8209979924569197`*^9, 3.8210703090807877`*^9, 3.821075525859519*^9},
 CellLabel->
  "Out[101]=",ExpressionUUID->"a8594ff5-5c52-4900-8bd5-cf80399a1306"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y", "=", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"convertDoubleQWORD", "[", "16^^3fd3333333333334", "]"}], ",", 
    "200"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.820932043967929*^9, 3.820932049874626*^9}},
 CellLabel->
  "In[102]:=",ExpressionUUID->"5318281d-37fe-4743-8c38-273f8f6b1f91"],

Cell[BoxData["0.3000000000000000444089209850062616169452667236328125`200."], \
"Output",
 CellChangeTimes->{{3.820932044367456*^9, 3.820932050196286*^9}, 
   3.820997992469659*^9, 3.821070309198777*^9, 3.821075525975527*^9},
 CellLabel->
  "Out[102]=",ExpressionUUID->"43910fef-0c8e-4e6f-99ba-8dabaa5800e4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"Import", "[", 
   RowBox[{"\"\<~/tmp/test\>\"", ",", "\"\<CSV\>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8209989455462103`*^9, 3.820998965347677*^9}, {
  3.820999048265917*^9, 3.820999049219736*^9}, {3.820999126494499*^9, 
  3.820999129338284*^9}, {3.8209992145529118`*^9, 3.82099925677874*^9}, {
  3.820999333759297*^9, 3.820999358288951*^9}},
 CellLabel->
  "In[103]:=",ExpressionUUID->"a20f6be2-cacb-44af-a1b2-ed1e1c18507e"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"3796174982", ",", 
             RowBox[{"-", "9.086557`*^20"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"4182529786", ",", 
             RowBox[{"-", "6.631204`*^34"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2180050607", ",", 
             RowBox[{"-", "8.850457`*^-38"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3809380472", ",", 
             RowBox[{"-", "2.629271`*^21"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2960793660", ",", 
             RowBox[{"-", "9.099528`*^-10"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"4051247694", ",", 
             RowBox[{"-", "1.233652`*^30"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3989107140", ",", 
             RowBox[{"-", "7.618917`*^27"}]}], "}"}], ",", 
           TemplateBox[{"65521"},
            "OutputSizeLimit`Skeleton"], ",", 
           RowBox[{"{", 
            RowBox[{"590415695", ",", "9.596737`*^-18"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2223441286", ",", 
             RowBox[{"-", "3.174342`*^-36"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3830508573", ",", 
             RowBox[{"-", "1.541575`*^22"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1889155465", ",", "3.81842`*^29"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2449703937", ",", 
             RowBox[{"-", "4.149902`*^-28"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3631525448", ",", 
             RowBox[{"-", "1.076117`*^15"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3024859991", ",", 
             RowBox[{"-", "1.897109`*^-7"}]}], "}"}]}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{80., {3., 10.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{72., {0., 10.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 103, 30508851898383789437, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{81., {0., 10.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 103, 30508851898383789437, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{61., {0., 10.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 103, 30508851898383789437, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{110., {0., 10.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[30508851898383789437 === $SessionID, 
   Out[103], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{{3.82099895131565*^9, 3.820998967784088*^9}, 
   3.8209990526219387`*^9, 3.820999129670383*^9, {3.820999217634943*^9, 
   3.8209992570160723`*^9}, {3.8209993377387733`*^9, 3.820999360083701*^9}, 
   3.821070311230916*^9, 3.8210755274898653`*^9},
 CellLabel->
  "Out[103]=",ExpressionUUID->"5794ae17-0fdb-4539-80ca-d372ac17d729"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"getError", "[", 
   RowBox[{"ref_", ",", "my_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"convertFloatDWORD", "[", "my", "]"}], "-", "ref"}], ")"}], "/", 
   "ref"}]}]], "Input",
 CellChangeTimes->{{3.820999611606124*^9, 3.820999625590679*^9}, {
  3.820999794409092*^9, 3.8209998002663193`*^9}, {3.820999840838155*^9, 
  3.8209998655115843`*^9}},
 CellLabel->
  "In[104]:=",ExpressionUUID->"f6d1ba68-f7de-4e55-9185-e2f5f9d0cd8d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"getError", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "a", "]"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.820999944979701*^9, 3.8210000152408543`*^9}},
 CellLabel->
  "In[105]:=",ExpressionUUID->"fcb193fe-e7e3-41bc-9d33-8adc14cd9fc2"],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"4.983733095177341`*^-7", ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "\<\"-nan\"\>"}], "+", "\<\"NaN\"\>"}], "\<\"-nan\"\>"], 
   ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "\<\"nan\"\>"}], "+", "\<\"NaN\"\>"}], "\<\"nan\"\>"]}], 
  "]"}]], "Output",
 CellChangeTimes->{{3.820999963608921*^9, 3.8210000202968063`*^9}, 
   3.821070315941197*^9, 3.821075530813068*^9},
 CellLabel->
  "Out[105]=",ExpressionUUID->"220de2bc-7874-44f3-977d-a6ab9fc1d750"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"getError", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "a", "]"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.821000028453277*^9, 3.82100002852234*^9}},
 CellLabel->
  "In[106]:=",ExpressionUUID->"ff29c6c7-314f-4723-bfa2-0568103e33b9"],

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{
   RowBox[{"-", "4.87251825759246`*^-7"}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "\<\"-nan\"\>"}], "+", "\<\"NaN\"\>"}], "\<\"-nan\"\>"], 
   ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "\<\"nan\"\>"}], "+", "\<\"NaN\"\>"}], "\<\"nan\"\>"]}], 
  "]"}]], "Output",
 CellChangeTimes->{3.82100003177464*^9, 3.821070319267414*^9, 
  3.821075533966405*^9},
 CellLabel->
  "Out[106]=",ExpressionUUID->"2ae0b557-0415-4a71-a9a1-89e5320497d8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"convertDoubleQWORD", "[", "16^^3fb999999999999a", "]"}], ",", 
    "100"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.821071079290765*^9, 3.8210710793232927`*^9}, {
  3.8210719719921*^9, 3.8210719720752773`*^9}},
 CellLabel->
  "In[107]:=",ExpressionUUID->"e8d6cb0b-a16c-4049-bd68-4abb5910e300"],

Cell[BoxData["0.1000000000000000055511151231257827021181583404541015625`100."]\
, "Output",
 CellChangeTimes->{{3.821071077611884*^9, 3.821071079634057*^9}, 
   3.8210719727352467`*^9, 3.8210755341303596`*^9},
 CellLabel->
  "Out[107]=",ExpressionUUID->"d1e3ea86-dde4-4d2e-b00a-04fd6be32516"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", "=", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"convertDoubleQWORD", "[", "16^^3fc999999999999a", "]"}], ",", 
    "100"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.821071962038446*^9, 3.821071973908833*^9}},
 CellLabel->
  "In[108]:=",ExpressionUUID->"9ba22f52-d1ef-49c6-b00b-c57c9c46a2bb"],

Cell[BoxData["0.200000000000000011102230246251565404236316680908203125`100."],\
 "Output",
 CellChangeTimes->{{3.821071969470385*^9, 3.8210719742132397`*^9}, 
   3.821075534253862*^9},
 CellLabel->
  "Out[108]=",ExpressionUUID->"0f018367-c86d-4d3b-ae05-b0d47cc572df"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "+", "b"}]], "Input",
 CellChangeTimes->{{3.821071974828306*^9, 3.821071975470625*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"ee296437-1b0c-4dec-afe6-1aa8e4bacb3f"],

Cell[BoxData["0.3000000000000000166533453693773481063544750213623046875`100."]\
, "Output",
 CellChangeTimes->{3.821071975698224*^9, 3.821075534377315*^9},
 CellLabel->
  "Out[109]=",ExpressionUUID->"121388fa-4a31-4f8c-bd1a-fc630f9b85af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"convertDoubleQWORD", "[", "16^^3fd3333333333334", "]"}], ",", 
   "100"}], "]"}]], "Input",
 CellChangeTimes->{{3.82107198639837*^9, 3.821071990672818*^9}, {
  3.821072142005406*^9, 3.821072142087883*^9}},
 CellLabel->
  "In[110]:=",ExpressionUUID->"dc117b9a-826d-4918-8669-7acdeaf9ebda"],

Cell[BoxData["0.3000000000000000444089209850062616169452667236328125`100."], \
"Output",
 CellChangeTimes->{3.82107199153962*^9, 3.821072142448928*^9, 
  3.821075534500629*^9},
 CellLabel->
  "Out[110]=",ExpressionUUID->"dea7c4bb-e74b-4757-abbc-6c7b27b888ef"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"convertDoubleQWORD", "[", "16^^3fd3333333333334", "]"}], ",", 
    "100"}], "]"}], "-", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"convertDoubleQWORD", "[", "16^^3fd3333333333333", "]"}], ",", 
    "100"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.82107237071377*^9, 3.821072379088023*^9}},
 CellLabel->
  "In[111]:=",ExpressionUUID->"91e94a91-89f4-4bd8-912d-11bfc299505f"],

Cell[BoxData["5.5511151231257827021181583404541015625`83.96622898376135*^-17"]\
, "Output",
 CellChangeTimes->{3.821072379483191*^9, 3.821075534767645*^9},
 CellLabel->
  "Out[111]=",ExpressionUUID->"904c1cac-014b-42ce-85ea-d5f010d07a2a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"convertDoubleQWORD", "[", "16^^3fb999999999999a", "]"}], ",", 
   "100"}], "]"}]], "Input",
 CellLabel->
  "In[112]:=",ExpressionUUID->"43bd0512-86c3-48d4-a2b7-2fae0c90396a"],

Cell[BoxData["0.1000000000000000055511151231257827021181583404541015625`100."]\
, "Output",
 CellChangeTimes->{3.82107343392237*^9, 3.821075534895328*^9},
 CellLabel->
  "Out[112]=",ExpressionUUID->"b32fe8c7-d6c7-46b8-8ca3-7b496d6e8aa2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"convertFloatDWORD", "[", "16^^3dcccccd", "]"}], ",", "100"}], 
  "]"}]], "Input",
 CellLabel->
  "In[113]:=",ExpressionUUID->"cc681f06-8a4f-4d74-9667-249eaf71e359"],

Cell[BoxData["0.100000001490116119384765625`100."], "Output",
 CellChangeTimes->{3.821073444919105*^9, 3.821075534910429*^9},
 CellLabel->
  "Out[113]=",ExpressionUUID->"5f37981d-00b4-411f-a015-7ef12e2ad50b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"convertFloatDWORD", "[", 
    RowBox[{"16^^3dcccccd", "-", "1"}], "]"}], ",", "100"}], "]"}]], "Input",
 CellChangeTimes->{{3.821074109353794*^9, 3.821074109458562*^9}},
 CellLabel->
  "In[114]:=",ExpressionUUID->"737681e0-ed72-449a-9ac2-d4e928d23429"],

Cell[BoxData["0.0999999940395355224609375`100."], "Output",
 CellChangeTimes->{3.821074109809918*^9, 3.821075535040635*^9},
 CellLabel->
  "Out[114]=",ExpressionUUID->"6d30a253-647d-4dd6-acd7-a04f1de8eddd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"convertFloatDWORD", "[", 
    RowBox[{"16^^3dcccccd", "+", "1"}], "]"}], ",", "100"}], "]"}]], "Input",
 CellChangeTimes->{{3.821074113534615*^9, 3.821074114267559*^9}},
 CellLabel->
  "In[115]:=",ExpressionUUID->"e1554992-2d72-493b-b57f-83bc1428c329"],

Cell[BoxData["0.10000000894069671630859375`100."], "Output",
 CellChangeTimes->{3.821074114553993*^9, 3.8210755352377663`*^9},
 CellLabel->
  "Out[115]=",ExpressionUUID->"c1ecb4f7-5946-44e8-8caa-b2a55d3f3dfb"]
}, Open  ]]
},
WindowSize->{1678, 1024},
WindowMargins->{{1, Automatic}, {1, Automatic}},
Magnification:>1.25 Inherited,
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 451, 8, 39, "Input",ExpressionUUID->"188f409f-567c-4f1b-b03c-4c581df6d43e"],
Cell[1012, 30, 453, 7, 39, "Input",ExpressionUUID->"c062faf5-bdfe-4789-b81d-de774dedb2dd"],
Cell[1468, 39, 557, 10, 39, "Input",ExpressionUUID->"bac939df-2af5-4259-93ce-d053a209bca7"],
Cell[2028, 51, 609, 13, 39, "Input",ExpressionUUID->"587aee54-40b1-477d-a7e9-058a41733cd7"],
Cell[2640, 66, 547, 10, 39, "Input",ExpressionUUID->"d11f61b1-903a-4e52-98af-6b0b3e7d37db"],
Cell[3190, 78, 560, 11, 39, "Input",ExpressionUUID->"2148dff4-6723-4725-a551-169e8d422b4e"],
Cell[3753, 91, 1053, 26, 39, "Input",ExpressionUUID->"aa7ede3b-82eb-43da-bc7d-0363cc20e509"],
Cell[4809, 119, 652, 14, 39, "Input",ExpressionUUID->"fd8ff10e-c169-460e-aaa6-d6b6f166954c"],
Cell[5464, 135, 971, 25, 69, "Input",ExpressionUUID->"f56ad711-c795-4094-88c9-b608d7efbac1"],
Cell[6438, 162, 1062, 22, 69, "Input",ExpressionUUID->"629c0957-46c9-4a18-8ec5-578005987b49"],
Cell[7503, 186, 856, 19, 69, "Input",ExpressionUUID->"8ada960b-b2a2-4a4a-a40e-343b3c34c09a"],
Cell[CellGroupData[{
Cell[8384, 209, 331, 7, 39, "Input",ExpressionUUID->"bb8fe085-94ea-4257-a967-93925368a1b9"],
Cell[8718, 218, 589, 8, 44, "Output",ExpressionUUID->"af3e440f-e541-4fe2-8679-12137866537a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9344, 231, 215, 4, 39, "Input",ExpressionUUID->"3cfd193f-d28d-4829-9582-e51a589f7c57"],
Cell[9562, 237, 317, 4, 44, "Output",ExpressionUUID->"bfc1dff3-2b00-437e-ab73-599acb56a487"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9916, 246, 334, 7, 39, "Input",ExpressionUUID->"805e3d2e-49de-4575-a8fb-194815c1b09f"],
Cell[10253, 255, 344, 5, 44, "Output",ExpressionUUID->"0305b7b2-2254-4628-aff3-ce2cd0d495d1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10634, 265, 253, 5, 39, "Input",ExpressionUUID->"9fd06b3e-457a-4106-9cd1-072480eb364b"],
Cell[10890, 272, 329, 5, 44, "Output",ExpressionUUID->"6152fc81-0bc2-441f-b736-0cc18dd915c2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11256, 282, 255, 5, 39, "Input",ExpressionUUID->"473117a0-798d-42e5-8454-4c91e9c7618d"],
Cell[11514, 289, 313, 4, 44, "Output",ExpressionUUID->"a6ac8a6a-9e4c-4434-89b1-84bf7fb81021"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11864, 298, 253, 5, 39, "Input",ExpressionUUID->"c4b51dc7-f933-4b55-bb3c-3b103697b4de"],
Cell[12120, 305, 300, 4, 44, "Output",ExpressionUUID->"269b9dd4-a13f-4f15-a202-962253caa6ac"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12457, 314, 255, 5, 39, "Input",ExpressionUUID->"250cc3a9-74a4-4359-b680-50ac47e0b585"],
Cell[12715, 321, 304, 4, 44, "Output",ExpressionUUID->"023e49f1-cbe7-4156-9655-cfcfc81ac821"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13056, 330, 253, 5, 39, "Input",ExpressionUUID->"f63f463f-88c9-4358-b3af-a4e8715d7183"],
Cell[13312, 337, 306, 4, 44, "Output",ExpressionUUID->"daa294b3-551d-49b8-8d69-dd6824bbf334"]
}, Open  ]],
Cell[13633, 344, 503, 8, 39, "Input",ExpressionUUID->"dc32e443-46db-417a-aa3c-629621e96aa0"],
Cell[14139, 354, 506, 8, 39, "Input",ExpressionUUID->"583e15c4-720e-4270-b729-39403b8e0ce5"],
Cell[14648, 364, 611, 11, 39, "Input",ExpressionUUID->"718d6026-8023-4564-a8d8-759f3f8a244c"],
Cell[15262, 377, 657, 13, 39, "Input",ExpressionUUID->"101a0a72-1cb8-41fb-af46-0c270753c6c9"],
Cell[15922, 392, 603, 12, 39, "Input",ExpressionUUID->"824acd42-4e4d-4397-9662-6b690e37423a"],
Cell[16528, 406, 614, 12, 39, "Input",ExpressionUUID->"67329a55-0dea-4291-8c92-f825fb9124ac"],
Cell[17145, 420, 1107, 27, 39, "Input",ExpressionUUID->"e42fd4ce-7ba6-4dfd-ac0c-e18c7d16d672"],
Cell[18255, 449, 701, 14, 39, "Input",ExpressionUUID->"423b7336-e765-4818-8737-f086af2be42f"],
Cell[18959, 465, 1024, 26, 69, "Input",ExpressionUUID->"4c13ce6c-3a4c-4cd5-a5c9-58fd398b7d2d"],
Cell[19986, 493, 1112, 22, 69, "Input",ExpressionUUID->"03fc0046-e644-4e61-ad6f-f220d888225b"],
Cell[21101, 517, 914, 20, 69, "Input",ExpressionUUID->"9232e86e-171f-4a90-b8f3-8d1806a8042d"],
Cell[CellGroupData[{
Cell[22040, 541, 418, 9, 39, "Input",ExpressionUUID->"ba521d93-db3c-49c6-a60a-0d352454d220"],
Cell[22461, 552, 429, 6, 74, "Output",ExpressionUUID->"27eb767f-35a8-45a5-b112-51abb1b44e17"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22927, 563, 471, 9, 39, "Input",ExpressionUUID->"459fc1ed-9682-4d16-ac21-922fa650f5a0"],
Cell[23401, 574, 446, 7, 74, "Output",ExpressionUUID->"70162768-8c80-470f-807a-4b89addc2ca6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23884, 586, 344, 7, 39, "Input",ExpressionUUID->"8f9e6fe9-b026-44c7-b44c-ca51ee69439a"],
Cell[24231, 595, 343, 4, 74, "Output",ExpressionUUID->"0a0565b3-df1d-4533-b42a-62278f07c5bd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24611, 604, 323, 7, 39, "Input",ExpressionUUID->"405849d7-58c7-4728-aed7-deee704473af"],
Cell[24937, 613, 335, 5, 74, "Output",ExpressionUUID->"d68aa6d2-b006-4e4c-83af-a17de987df44"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25309, 623, 300, 5, 39, "Input",ExpressionUUID->"0f4a1613-ba6b-4d6d-803e-c766311e04e8"],
Cell[25612, 630, 415, 6, 74, "Output",ExpressionUUID->"9e1acd29-e22a-41fb-a2a1-237469aed4b9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26064, 641, 176, 2, 39, "Input",ExpressionUUID->"3e3b5804-f0a7-439d-8803-ef1fdd97b272"],
Cell[26243, 645, 302, 4, 74, "Output",ExpressionUUID->"f54f06b0-32a3-4877-8782-0f8cd503b404"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26582, 654, 214, 3, 39, "Input",ExpressionUUID->"c99c4855-daff-4c4a-a845-11a0a5b0060b"],
Cell[26799, 659, 285, 4, 74, "Output",ExpressionUUID->"b30a087a-32a1-4221-9258-3a062bd6043c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27121, 668, 253, 7, 39, "Input",ExpressionUUID->"2b523486-60cc-48f1-b096-264167a946a9"],
Cell[27377, 677, 458, 8, 74, "Output",ExpressionUUID->"f510c1f2-5609-46b4-943c-18dbbf8bee6b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27872, 690, 323, 8, 39, "Input",ExpressionUUID->"dcad13e8-9e57-42d8-a08f-5d59904c3de1"],
Cell[28198, 700, 315, 5, 74, "Output",ExpressionUUID->"a8594ff5-5c52-4900-8bd5-cf80399a1306"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28550, 710, 323, 8, 39, "Input",ExpressionUUID->"5318281d-37fe-4743-8c38-273f8f6b1f91"],
Cell[28876, 720, 307, 5, 74, "Output",ExpressionUUID->"43910fef-0c8e-4e6f-99ba-8dabaa5800e4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29220, 730, 478, 9, 39, "Input",ExpressionUUID->"a20f6be2-cacb-44af-a1b2-ed1e1c18507e"],
Cell[29701, 741, 10676, 272, 216, "Output",ExpressionUUID->"5794ae17-0fdb-4539-80ca-d372ac17d729"]
}, Open  ]],
Cell[40392, 1016, 493, 13, 39, "Input",ExpressionUUID->"f6d1ba68-f7de-4e55-9185-e2f5f9d0cd8d"],
Cell[CellGroupData[{
Cell[40910, 1033, 668, 19, 39, "Input",ExpressionUUID->"fcb193fe-e7e3-41bc-9d33-8adc14cd9fc2"],
Cell[41581, 1054, 515, 14, 63, "Output",ExpressionUUID->"220de2bc-7874-44f3-977d-a6ab9fc1d750"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42133, 1073, 665, 19, 39, "Input",ExpressionUUID->"ff29c6c7-314f-4723-bfa2-0568103e33b9"],
Cell[42801, 1094, 505, 15, 63, "Output",ExpressionUUID->"2ae0b557-0415-4a71-a9a1-89e5320497d8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43343, 1114, 374, 9, 39, "Input",ExpressionUUID->"e8d6cb0b-a16c-4049-bd68-4abb5910e300"],
Cell[43720, 1125, 292, 5, 44, "Output",ExpressionUUID->"d1e3ea86-dde4-4d2e-b00a-04fd6be32516"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44049, 1135, 323, 8, 39, "Input",ExpressionUUID->"9ba22f52-d1ef-49c6-b00b-c57c9c46a2bb"],
Cell[44375, 1145, 267, 5, 44, "Output",ExpressionUUID->"0f018367-c86d-4d3b-ae05-b0d47cc572df"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44679, 1155, 198, 4, 39, "Input",ExpressionUUID->"ee296437-1b0c-4dec-afe6-1aa8e4bacb3f"],
Cell[44880, 1161, 238, 4, 44, "Output",ExpressionUUID->"121388fa-4a31-4f8c-bd1a-fc630f9b85af"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45155, 1170, 345, 8, 39, "Input",ExpressionUUID->"dc117b9a-826d-4918-8669-7acdeaf9ebda"],
Cell[45503, 1180, 259, 5, 44, "Output",ExpressionUUID->"dea7c4bb-e74b-4757-abbc-6c7b27b888ef"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45799, 1190, 447, 12, 39, "Input",ExpressionUUID->"91e94a91-89f4-4bd8-912d-11bfc299505f"],
Cell[46249, 1204, 238, 4, 44, "Output",ExpressionUUID->"904c1cac-014b-42ce-85ea-d5f010d07a2a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46524, 1213, 231, 6, 39, "Input",ExpressionUUID->"43bd0512-86c3-48d4-a2b7-2fae0c90396a"],
Cell[46758, 1221, 237, 4, 44, "Output",ExpressionUUID->"b32fe8c7-d6c7-46b8-8ca3-7b496d6e8aa2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47032, 1230, 221, 6, 39, "Input",ExpressionUUID->"cc681f06-8a4f-4d74-9667-249eaf71e359"],
Cell[47256, 1238, 208, 3, 44, "Output",ExpressionUUID->"5f37981d-00b4-411f-a015-7ef12e2ad50b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47501, 1246, 309, 7, 39, "Input",ExpressionUUID->"737681e0-ed72-449a-9ac2-d4e928d23429"],
Cell[47813, 1255, 206, 3, 44, "Output",ExpressionUUID->"6d30a253-647d-4dd6-acd7-a04f1de8eddd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48056, 1263, 309, 7, 39, "Input",ExpressionUUID->"e1554992-2d72-493b-b57f-83bc1428c329"],
Cell[48368, 1272, 209, 3, 77, "Output",ExpressionUUID->"c1ecb4f7-5946-44e8-8caa-b2a55d3f3dfb"]
}, Open  ]]
}
]
*)

