#pragma once

#include <stdint.h>

#include <list>
#include <string>

// C++ utils
std::string strfmt (const char * szFormat, ...);
std::wstring wstrfmt (const wchar_t * szFormat, ...);

bool str_startswith (std::wstring prefix, std::wstring s);
std::wstring n_spaces (unsigned n);
bool string_is_in_list_of_strings (const std::list<std::wstring> & l, const std::wstring & s);
void die (const std::wstring & msg);

// copypasted from z3...
#define IF_VERBOSE(LVL, CODE) {             \
    if (verbosity_level >= LVL) {       \
        CODE;                       \
    } } ((void) 0)              

// https://stackoverflow.com/questions/14421656/is-there-widely-available-wide-character-variant-of-file
#define WIDE2(x) L##x
#define WIDE1(x) WIDE2(x)
#define WFILE WIDE1(__FILE__)

#define WFUNCTION WIDE1(__FUNCTION__)

std::wstring utf8_to_utf16(std::string utf8_string);
std::string utf16_to_utf8(std::wstring utf16_string);
uint64_t hexstring_to_int (std::string s);
void* my_memdup (void *src, size_t size);
void my_bzero (void *dst, size_t size);
bool iequals(const std::string& a, const std::string& b);
bool iequals(const std::wstring& a, const std::wstring& b);

/* vim: set expandtab ts=4 sw=4 : */
