#!/usr/bin/env python3
import random

# https://stackoverflow.com/q/567222
def is_prime(num):
    """Returns True if the number is prime else False."""
    if num == 0 or num == 1:
        return False
    for x in range(2, num):
        if num % x == 0:
            return False
    else:
        return True
    
primes=[i for i in range(1, 10000) if is_prime(i)]
# random prime:
p=random.choice(primes)
# random x:
x=random.randint(1, 10*10)
assert pow(x, p-1, p)==1
