#include <assert.h>
#include <stdio.h>

#define ENGLISH (1<<0)
#define FRENCH  (1<<1)
#define GERMAN  (1<<2)
#define SPANISH (1<<3)
#define RUSSIAN (1<<4)
#define ARABIC  (1<<5)
#define CHINESE (1<<6)
// all languages:
#define UNIVERSE (ENGLISH | FRENCH | GERMAN | SPANISH | RUSSIAN | ARABIC | CHINESE)

#define JOHN_CAN_SPEAK         (ENGLISH | FRENCH)
#define JOHN_CAN_UNDERSTAND    (JOHN_CAN_SPEAK | RUSSIAN | GERMAN)

#define PETER_CAN_SPEAK        (ENGLISH | GERMAN)
#define PETER_CAN_UNDERSTAND   (PETER_CAN_SPEAK | SPANISH | ARABIC)

#define NATASHA_CAN_SPEAK      (ENGLISH | RUSSIAN)
#define NATASHA_CAN_UNDERSTAND (NATASHA_CAN_SPEAK | CHINESE)

#define JOHN_AND_PETER_CAN_UNDERSTAND (JOHN_CAN_UNDERSTAND | PETER_CAN_UNDERSTAND)

int main()
{
    // which languages can JOHN and PETER use to talk with each other?
    // this is 'set intersection'
    assert ((JOHN_CAN_SPEAK & PETER_CAN_SPEAK) == ENGLISH);

    // which languages can Peter speak so that John would understand him?
    // 'set intersection' again
    assert ((PETER_CAN_SPEAK & JOHN_CAN_UNDERSTAND) == (ENGLISH | GERMAN));

    // which languages can John speak so that Peter would understand him?
    assert ((JOHN_CAN_SPEAK & PETER_CAN_UNDERSTAND) == ENGLISH);

    // which languages can John use so that both Peter and Natasha will understand him?
    assert ((JOHN_CAN_SPEAK & (PETER_CAN_UNDERSTAND & NATASHA_CAN_UNDERSTAND)) == ENGLISH);

    // which languages both JOHN and PETER can't speak/understand?
    // this is 'set complement'
    assert (((~JOHN_AND_PETER_CAN_UNDERSTAND) & UNIVERSE) == CHINESE);

    // which languages JOHN can speak that PETER don't?
    // this is 'set subtraction' or 'difference of sets'
    // in other words, clear all bits in JOHN\_CAN\_SPEAK that present in PETER\_CAN\_SPEAK
    assert ((JOHN_CAN_SPEAK & (~PETER_CAN_SPEAK)) == FRENCH);

    // which languages PETER can speak that JOHN don't?
    assert ((PETER_CAN_SPEAK & (~JOHN_CAN_SPEAK)) == GERMAN);

    // how many languages our group of 3 persons can speaks?
    // this is 'cardinality' of set
    // we're using a popcount() function here to count all bits in ORed values
    assert (__builtin_popcount (JOHN_CAN_SPEAK | PETER_CAN_SPEAK | NATASHA_CAN_SPEAK)==4);

    // which languages can be spoken/understood only by one person in a pair?
    // (a language spoken by both persons is 'eliminated' by XOR operation.)
    assert ((JOHN_CAN_UNDERSTAND ^ PETER_CAN_UNDERSTAND) == (FRENCH | RUSSIAN | ARABIC | SPANISH));
};

/* vi: set sw=4 ts=4: */
