#!/usr/bin/env python3

_min=10
_max=0

def popcnt(x):
    # https://stackoverflow.com/q/9829578
    return bin(x).count("1")

for p1 in range(2**10): # from 0b0000000000 to 0b1111111111
    if popcnt(p1)!=7:
        continue
    for p2 in range(2**10): # from 0b0000000000 to 0b1111111111
        if popcnt(p2)!=8:
            continue
        # at this point, p1 can take all possible values where sum of bits == 7
        # ... p2 == 8
        x=popcnt (p1 & p2)
        if x==5 or x==7:
            print ("-")
            print ("park1 {0:010b}".format(p1), "(%d)" % popcnt(p1))
            print ("park2 {0:010b}".format(p2), "(%d)" % popcnt(p2))
            print ("both  {0:010b}".format(p1 & p2), "(%d)" % popcnt(p1 & p2))
        # write down min/max values of x:
        _min=min(_min, x)
        _max=max(_max, x)
    
print ("min:", _min)
print ("max:", _max)

