#include <assert.h>

#define DRUMS  (1<<0)
#define GUITAR (1<<1)
#define BASS   (1<<2)
#define VOCAL  (1<<3)

// what each rocker can do in our band:
#define JOHN_CAN_PLAY    (GUITAR | BASS)
#define JAKE_CAN_PLAY    (GUITAR | VOCAL)
#define PETER_CAN_PLAY   (GUITAR | DRUMS)
#define MICHAEL_CAN_PLAY (DRUMS | VOCAL)
#define FRANK_CAN_PLAY   (GUITAR | BASS | DRUMS)

// instruments that must be used
// internally, this is 0xf (4 lowest bits)
// this is set universe
#define ROCK_BAND_INSTRUMENTS (GUITAR | BASS | DRUMS | VOCAL)

// we single out one instrument from each rocker using AND
// then we join them all together using OR, this is 'set union'
// note: we 'take' two instruments from JAKE
// internally, this also must be 0xf (4 lowest bits)
#define STAR_ROCK_BAND  (JAKE_CAN_PLAY & GUITAR) | (JAKE_CAN_PLAY & VOCAL) | (JOHN_CAN_PLAY & BASS) | (PETER_CAN_PLAY & DRUMS)

int main()
{
    // this equation must hold:
    assert(STAR_ROCK_BAND==ROCK_BAND_INSTRUMENTS);
};

/* vi: set sw=4 ts=4: */
